#include <WiFi.h>
#include <WiFiClientSecure.h>
#include <LovyanGFX.hpp>
#include "LGFX_ST7735.h"    //(自作分)ST7735S Display用のLGFXの設定
#include <BME280I2C.h>      //温湿圧(BME280)のI2C制御
#include <Wire.h>
#include "hardware/watchdog.h"
#include <time.h>
#include <TimeLib.h>
#include "WiFi_Ntp_Line.h"  //(自作分)WiFi接続、SNTPから時刻を取得、LINE送信作業
#include <LittleFS.h>       //ファイルシステム(ツール-Flash Size、64K に設定)
#include "WR_FileSystem.h"  //(自作分)ファイル読み書き

const String FileVersion = "SendingLineOfficial7.ino";
String ssid = "xxxxxxxx";
String password = "yyyyyyyy";
String host     = "api.line.me";
String token = "zzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzz";

const int LED = 21, SW1 = 20, SW2 = 19, SW3 = 18;
char buf[80], buf2[30];    // sprintf用のBuffer
unsigned long start_time;  //実行時間計測用
int TmStart = 300;         //5:00  起点時間(分)
int TmInterval = 1440;     //24h   通報間隔(分)
int Reserve = 0;
int NoLineFlg = 0;         //前回Line送出に失敗したFlag

BME280I2C bme;    // Default : forced mode, standby time = 1000 ms
                  // Oversampling = pressure ×1, temperature ×1, humidity ×1, filter off,

void restartPico() {
    LittleFS.end();
    delay(500);
    rp2040.restart();
}

float temp, hum, pres;  // 温度・湿度・気圧をBME280から取得した数値

void setup() {
  Serial.begin(115200); // シリアルポート設定
  delay(1000);          // シリアル初期化が安定するまで待つ
  //while (!Serial) { delay(10); }  // シリアルポートが開くのを待つ(相手が無いと固まる)
  pinMode(LED, OUTPUT); pinMode(SW1, INPUT_PULLUP); pinMode(SW2, INPUT_PULLUP);
  pinMode(SW3, INPUT_PULLUP);

  //Serial.print("Pico W MACアドレス: "); Serial.println(WiFi.macAddress());

  // ファイルシステムの初期設定
  if (!LittleFS.begin()) {
    Serial.println("LittleFS mount failed");
    restartPico();
  }
  Serial.println("LittleFS mounted successfully");

  // ディスプレイの初期設定
  lcd.init();
  lcd.setRotation(1); // 0, 1, 2, 3  1:右に90°回転する(x,yの座標は新座標で有効)
  lcd.setTextColor(TFT_WHITE, TFT_BLACK);
  lcd.setTextSize(1); //明朝12,1こんにちは、世界！,2こんにちは、,3こんにち
  canvas.setTextWrap(true);	      // 画面右で折り返す設定
  canvas.createSprite(160, 128);	// 画面サイズでキャンバス用のメモリを確保
  canvas.fillScreen(TFT_BLACK);	  // 黒で塗りつぶし
  canvas.setTextColor(TFT_WHITE, TFT_BLACK);	// 文字色は白

  // BME280の初期設定
  Wire.setSDA(8); Wire.setSCL(9);
  Wire.begin(); bme.begin();
  BME280::TempUnit tempUnit(BME280::TempUnit_Celsius); //単位を指定できる
  BME280::PresUnit presUnit(BME280::PresUnit_hPa);

  //電源ON時、SET_SWが5秒間押すとsectrts.datとparameter.datの編集入る
  if (StateSetSW(1) == 3) EditImportantData();

  //各種設定ファイルの読み込み
  loadSecrets();      //WiFiその他の接続用データ取得
  loadParameters();   //定時通報・その他のデータ取得
  loadNoLineFlg();    //前回のLine送出フラグを取得
  //Serial.printf("NoLineFlg: %d\n", NoLineFlg);  //for Test
  //saveSecretsBackup(); //for Test、secrets.datのBackUpを取る

  ConectingWiFi();    // ========  WiFi への接続  ========
  //FileWRtest();     //for Test、LittleFSによる読み書きテスト
  
  delay(1000);        // Wi-Fi 接続後、安定するまで待つ
  setClock(0);        // ===== sntpで年月曜時刻を取得 =====
}

unsigned long cnt = 0;

void loop() {
  if ((cnt++ % 5) == 0) bme.read(pres, temp, hum);  //BME280から環境情報を取得する

  // Line送出：UpSW 2秒押し、未送Flag ON、定時通報検出
  if(ChkSWNoChatt(1,2000) || NoLineFlg || FixTmMes()){  //LINE送出の条件
    SendToLine();         //LINEへメッセージを送出する
    if (NoLineFlg) { NoLineFlg = 0; saveNoLineFlg(0); } //未送信Flagをクリア
    delay(1000);
  } else {
    Disp_Environment();   //時刻・温度・湿度・気圧をLCDに表示する
    if (StateSetSW(1) == 3) EditFixTmMesData();       //SET SW 5秒押しで定時通報時間編集へ
    if (ChkSWNoChatt(0,2000)) setClock(1);            //Down SW 2秒押しで時刻取得へ
    if ((DayS != (int)day()) && ((int) minute() >= 12)) setClock(0); //日一度,時刻の校正
  }
  delay(100);
}
