// LovyanGFXのディスプレイクラスを継承したカスタムクラス
class LGFX : public lgfx::LGFX_Device
{
  lgfx::Panel_ST7735S _panel_instance;	// ST7735Sパネルのインスタンス
  lgfx::Bus_SPI       _bus_instance;	  // SPIバスのインスタンス

public:
  LGFX(void)
  {
    // SPIバスの設定
    auto cfg = _bus_instance.config();
    cfg.spi_host = 0;           // Raspberry Pi Picoでは 0 (SPI0) または 1 (SPI1) を指定
    cfg.spi_mode = 0;            // SPIモード
    cfg.freq_write = 20000000;   // 書き込み時のSPIクロック（20MHz）
    cfg.freq_read  = 16000000;   // 読み込み時のSPIクロック（16MHz）
    cfg.pin_sclk = 2;            // SCLKピン（GP2）
    cfg.pin_mosi = 3;            // MOSIピン（GP3）
    cfg.pin_miso = -1;           // MISOピン（未使用）
    cfg.pin_dc   = 11;           // DCピン（GP11）
    _bus_instance.config(cfg);
    _panel_instance.setBus(&_bus_instance);

    // パネルの設定
    auto pcfg = _panel_instance.config();
    pcfg.pin_cs   = 1;           // CSピン（GP1）
    pcfg.pin_rst  = 10;          // RSTピン（GP10）
    pcfg.pin_busy = -1;          // BUSYピン（未使用）
      // setRotation(0)の感覚で
    pcfg.memory_width  = 128;    // メモリ上の幅   128
    pcfg.memory_height = 160;    // メモリ上の高さ 128(変更でST7735の全画面に表示OKとなった)
    pcfg.panel_width   = 128;    // 実際の表示幅   128
    pcfg.panel_height  = 160;    // 実際の表示高さ 128(変更でST7735の全画面に表示OKとなった)
      // setRotation(1)の感覚で(x,y逆転)
    pcfg.offset_x      = -1;     // X方向のオフセット(上が欠けていたので。-1:OK)
    pcfg.offset_y      = 1;      // Y方向のオフセット(左を修正。1:OK)
    pcfg.offset_rotation = 0;    // 回転時のオフセット
    pcfg.dummy_read_pixel = 8;   // ピクセル読み込み時のダミーリード数
    pcfg.dummy_read_bits  = 1;   // ビット読み込み時のダミーリード数
    pcfg.readable = false;       // 読み込み可能か
    pcfg.invert    = false;      // 色を反転するか
    pcfg.rgb_order = true;       // RGB順, false:R->B, true:R->R これで正しく出た
    pcfg.dlen_16bit = false;     // 16ビット長のデータを使用するか
    pcfg.bus_shared = true;      // バスを共有するか
    
    _panel_instance.config(pcfg);
    setPanel(&_panel_instance);
  }
};

extern char buf[], buf2[];        // sprintf用のBuffer
extern float temp, hum, pres;
extern int year(),month(),day(),hour(),minute(),second();    
extern const int LED;
extern const int SW1;
extern const int SW2;
extern const int SW3;
static LGFX lcd;
static LGFX_Sprite canvas(&lcd);  //Spriteのインスタンスを生成

//単発のメッセージを表示する
void display(int x, int y, const String dispayData){
  canvas.setFont(&fonts::lgfxJapanMincho_20); // 明朝体（8,12,16,20,24,28,32,36,40）
  canvas.fillScreen(TFT_BLACK);
  canvas.setCursor(x, y);   //canvas.setCursor(0, 0);
  canvas.println(dispayData);
  canvas.pushSprite(0, 0);  //SpriteをLCDへ転送
}

//時刻・測定結果などを表示する
void Disp_Environment() {
    canvas.fillScreen(TFT_BLACK);
    canvas.setTextColor(TFT_WHITE, TFT_BLACK);
    canvas.setFont(&fonts::lgfxJapanMincho_16);
    canvas.setCursor(0, 2);
    sprintf(buf2, "%04d-%02d-%02d %02d:%02d:%02d",
          year(), month(), day(), hour(), minute(), second());    
    canvas.printf("%s", buf2);
    //--------- 入出力のテスト表示(小さな文字) --------
    /*if (digitalRead(SW1)) digitalWrite(LED, HIGH); else digitalWrite(LED, LOW);
    canvas.setFont(&fonts::lgfxJapanMincho_8);
    canvas.setCursor(0, 16);
    sprintf(buf, "%d-%d-%d-%d",digitalRead(SW1),digitalRead(SW2),
                                                digitalRead(SW3),digitalRead(LED));
    canvas.printf("%s", buf);*/
    //------------------------------------------------
    canvas.setCursor(0, 25);
    canvas.setFont(&fonts::lgfxJapanMincho_28); // 明朝体(8,12,16,20,24,28,32,36,40)
    canvas.printf("温度:%.1f", temp);  //半角°(ALT+0176)
    canvas.setCursor(0, 60);
    canvas.printf("湿度:%.1f", hum);
    canvas.setCursor(0, 95);
    canvas.printf("気圧:%.0f", pres);
    canvas.setFont(&fonts::lgfxJapanMincho_16);
    canvas.setCursor(144, 33);      //注！145では改行する
    canvas.print("℃");
    canvas.setCursor(144, 67);
    canvas.print("％");
    canvas.setCursor(135, 104);
    canvas.print("hPa");
    canvas.pushSprite(&lcd, 0, 0);  //SpriteをLCDへ転送
}
